<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductContentController;
use App\Http\Controllers\AmazonController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\OpenAiController;
use App\Http\Middleware\AuthenticateApiToken;

Route::middleware('auth')->group(function () {
    Route::post('/generate-product-content', [ProductContentController::class, 'generate']);
});
// Route::middleware(['auth'])->group(function () {
    Route::post('/amazon/search', [AmazonController::class, 'search_product']);
    Route::post('/amazon/get_product/{asin}', [AmazonController::class, 'get_product']);
    Route::get('/amazon/fetch-details/{title}', [AmazonController::class, 'fetch_product_details']);
    Route::get('/amazon/download-images/{title}', [AmazonController::class, 'download_images']);
    Route::get('/openai/generate-content/{title}', [OpenAiController::class, 'generate_content']);
    Route::get('/openai/generate-review-content/{title}', [OpenAiController::class, 'generate_review_content']);
    Route::post('/create_collage', [HomeController::class, 'create_collage']);
    Route::get('/wp/publish-content/{title}', [HomeController::class, 'publish_content']);
    Route::get('/wp/publish-review-content/{title}', [HomeController::class, 'publish_review_content']);
// });

Route::post('/auth/login', [AuthController::class, 'login']);
Route::post('/auth/logout', [AuthController::class, 'logout'])->middleware(AuthenticateApiToken::class);

// Simple API test route
Route::get('/ping', function () {
    return response()->json(['ping' => true]);
});
