<?php
/**
 * Plugin Name: Laravel Content Manager Assets
 * Description: Manages CSS and JS assets required for content imported from the Laravel API.
 * Version: 1.0
 * Author: Your Name
 * Text Domain: lcm
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Enqueue custom styles and scripts for the frontend.
 * This function hooks into 'wp_enqueue_scripts'.
 */
function lcm_enqueue_assets() {
    // --- 1. ENQUEUE CSS ---
    // Use the plugins_url() function to correctly locate your CSS file.
    wp_enqueue_style(
        'lcm-style', // Unique handle name for the stylesheet
        plugins_url( 'css/laravel-style.css', __FILE__ ), // Full URL path
        array(), // Dependencies (none for basic style)
        '1.0.0' // Version number (helps with cache busting)
    );

    // --- 2. ENQUEUE JAVASCRIPT ---
    // The script is dependent on 'jquery' and will be loaded in the footer (true).
    wp_enqueue_script(
        'lcm-script', // Unique handle name for the script
        plugins_url( 'js/laravel-script.js', __FILE__ ), // Full URL path
        array( 'jquery' ), // Dependencies (required for jQuery functionality)
        '1.0.0', // Version number
        true // Load in the footer (best for performance)
    );
}
// Hook the function to the 'wp_enqueue_scripts' action
add_action( 'wp_enqueue_scripts', 'lcm_enqueue_assets' );