<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class AuthenticateApiToken
{
    public function handle(Request $request, Closure $next)
    {
        $auth = $request->header('Authorization') ?: $request->bearerToken();
        if (!$auth) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        // Support both 'Bearer token' and raw token
        if (str_starts_with($auth, 'Bearer ')) {
            $token = substr($auth, 7);
        } else {
            $token = $auth;
        }

    $hashed = hash('sha256', $token);
    $user = User::where('api_token', $hashed)->first();
        if (!$user) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

    // Authenticate for the duration of the request
    Auth::setUser($user);

        return $next($request);
    }
}
