<?php

namespace App\Http\Controllers;

use App\Models\Contents;
use App\Models\Product;
use App\Models\Prompt;
use Illuminate\Http\Request;
use App\Services\OpenAIService;
use Illuminate\Support\Facades\Storage;

class OpenAiController extends Controller
{
    function generate_content(OpenAIService $openAI, $title)
    {
        $promptTemplate = Prompt::where('type', 'single_product')
            ->inRandomOrder()
            ->first();
        $promptTemplate_multi = Prompt::where('type', 'multi_products')
            ->inRandomOrder()
            ->first();
        
            $data = Storage::disk('local')->get('products/' . $title . '.json');
        $data = json_decode($data, true);
        $urls = [];
        for ($i = 0; $i < ($data['request_parameters']['include_products_count']); $i++) {
            $asin = $data['search_results'][$i]['asin'];
            $product=Product::where('asin',$asin)->first()->toArray();
            $urls[]=$product['product_url'];
            $finalPrompt = $this->preparePrompt($promptTemplate->content,$promptTemplate->key_title, $product);
            $response = $openAI->generateContent($finalPrompt);
            // Save response to file
            Storage::disk('local')->put('openai_responses/' . $asin . '_response.txt', $response);
            $prod['contents']=json_decode($response,true);
            Product::where('asin',$asin)->update($prod);
        }
        $placeholders=['{{urls}}'=>implode("\n", $urls),'{{keys}}' => $promptTemplate_multi->key_title ?? '',];
        $multiPrompt = strtr($promptTemplate_multi->content, $placeholders);
        $multiResponse = $openAI->generateContent($multiPrompt);
        Storage::disk('local')->put('openai_responses/' . $title . '_multi_response.txt', $multiResponse);
        $contents['filename']=$title;
        $contents['contents']=$multiResponse;
        Contents::create($contents);
        return response()->json([
            'status' => 'success',
            'message' => 'Content generated successfully',
        ]);
    }
    function generate_review_content(OpenAIService $openAI, $title)
    {
        $promptTemplate = Prompt::where('type', 'single_product')
            ->inRandomOrder()
            ->first();
        $promptTemplate_multi = Prompt::where('type', 'multi_products')
            ->inRandomOrder()
            ->first();
        
            $data = Storage::disk('local')->get('products/' . $title . '.json');
        $data = json_decode($data, true);
        $urls = [];
        for ($i = 0; $i < ($data['request_parameters']['include_products_count']); $i++) {
            $asin = $data['search_results'][$i]['asin'];
            $product=Product::where('asin',$asin)->first()->toArray();
            $urls[]=$product['product_url'];
            $finalPrompt = $this->preparePrompt($promptTemplate->content,$promptTemplate->key_title, $product);
            $response = $openAI->generateContent($finalPrompt);
            // Save response to file
            Storage::disk('local')->put('openai_responses/' . $asin . '_response.txt', $response);
            $prod['contents']=json_decode($response,true);
            Product::where('asin',$asin)->update($prod);
        }
        $placeholders=['{{urls}}'=>implode("\n", $urls),'{{keys}}' => $promptTemplate_multi->key_title ?? '',];
        $multiPrompt = strtr($promptTemplate_multi->content, $placeholders);
        $multiResponse = $openAI->generateContent($multiPrompt);
        Storage::disk('local')->put('openai_responses/' . $title . '_multi_response.txt', $multiResponse);
        $contents['filename']=$title;
        $contents['contents']=$multiResponse;
        Contents::create($contents);
        return response()->json([
            'status' => 'success',
            'message' => 'Content generated successfully',
        ]);
    }
    private function preparePrompt($template,$keys, $product)
    {
        $placeholders = [
            '{{product_name}}' => $product['title'] ?? '',
            '{{product_link}}' => $product['product_url'] ?? '',            
            '{{keys}}' => $keys ?? '',
        ];

        return strtr($template, $placeholders);
    }
}
