<?php

namespace App\Http\Controllers;

use Log;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Intervention\Image\ImageManager;
use App\Services\AmazonProductService;
use App\Services\ImageService;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Drivers\Imagick\Driver;
use Intervention\Image\Exceptions\NotReadableException;

class AmazonController extends Controller
{
    public function __construct(protected AmazonProductService $amazon) {}

    function search_product(Request $request)
    {
        $keyword = $request->input('keywords');
        $product_count = $request->input('product_count', 5);

        $data = $this->amazon->fetch_products($keyword, $product_count);
        $title = time();
        Storage::disk('local')->put(
            'products/' . $title . '.json',
            json_encode($data, JSON_PRETTY_PRINT)
        );
        return response()->json(['data' => $data, 'stored_as' => $title]);
    }
    function get_product(string $asin)
    {
        $data = $this->amazon->fetch_product_by_asin($asin);
        return response()->json($data);
    }
    function fetch_product_details($title, AmazonProductService $amazon)
    {
        // Fetch main product list
        $json = Storage::disk('local')->get("products/{$title}.json");
        $data = json_decode($json, true);

        // Calculate product count (minimum 5)
        $requested = $data['request_parameters']['include_products_count'];
        $available = count($data['search_results']);

        // Minimum 5 but also not more than available results
        $count = min(max(5, $requested), $available);

        // Ensure single-product directory exists
        Storage::disk('local')->makeDirectory("products/single");

        for ($i = 0; $i < $count; $i++) {

            $asin = $data['search_results'][$i]['asin'];
            $d = $amazon->fetch_product_by_asin($asin);
            $p = $d['product'] ?? [];

            $product = new Product();
            $product->asin       = $p['asin'] ?? '';
            $product->title      = $p['title'] ?? '';
            $product->main_image = $p['main_image']['link'] ?? '';
            $product->price      = $p['buybox_winner']['price']['value'] ?? 0;

            // Keywords
            $product->keywords = is_array($p['keywords'])
                ? implode(',', $p['keywords'])
                : ($p['keywords'] ?? '');

            // Description
            if (isset($p['description'])) {
                $product->description = is_array($p['description'])
                    ? json_encode($p['description'])
                    : ($p['description'] ?? '');
            }else {
                $product->description = '';
            }


            // Arrays → JSON
            $product->specifications = json_encode($p['specifications'] ?? []);
            $product->images         = json_encode($p['images'] ?? []);

            $product->product_url = $p['link'] ?? '';
            $product->filename    = "{$title}_{$i}";

            $product->save();

            // Save individual product JSON
            Storage::disk('local')->put(
                "products/single/{$title}_{$i}.json",
                json_encode($d, JSON_PRETTY_PRINT)
            );
        }
        return ['status' => 'completed', 'products_processed' => $count];
    }
    function download_images($title, ImageService $image)
    {
        // Fetch main product list
        $json = Storage::disk('local')->get("products/{$title}.json");
        $data = json_decode($json, true);

        // Calculate product count (minimum 5)
        $requested = $data['request_parameters']['include_products_count'];
        $available = count($data['search_results']);

        // Minimum 5 but also not more than available results
        $count = min(max(5, $requested), $available);

        for ($i = 0; $i < $count; $i++) {
            $asin = $data['search_results'][$i]['asin'];
            $product = Product::where('asin', $asin)->first();
            if ($product) {
                $product->main_image_local = $image->downloadImage($product->main_image);
            }
            $images=[];
            foreach ($product->images as $img) {
                $images[]=$image->downloadImage($img['link']);
            }
            $product->images_local = json_encode($images);
            $product->save();
        }
        return ['status' => 'images downloaded', 'products_processed' => $count];
    }
}
