<?php

namespace App\Helpers;

class ArrayHelper
{
    public static function getValue($data, $key, $default = null)
    {
        // Convert object to array
        if (is_object($data)) {
            $data = (array) $data;
        }

        if (!is_array($data)) {
            return $default;
        }

        // Direct key access
        if (array_key_exists($key, $data)) {
            return $data[$key];
        }

        // Normalize key: space, slash, hyphen → underscore
        $normalized = str_replace([' ', '-', '/'], '_', $key);

        foreach ($data as $k => $v) {
            $cleanKey = str_replace([' ', '-', '/'], '_', $k);
            if ($cleanKey === $normalized) {
                return $v;
            }
        }

        return $default;
    }
    public static function normalize_key($key)
    {
        return strtolower(str_replace(' ', '', $key));
    }
}
